/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.particle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jayjay.dangerzone.entity.EntityParticle;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleEngine {
    protected World level;
    private List<EntityParticle> particles = new CopyOnWriteArrayList<EntityParticle>();

    public ParticleEngine(World level) {
        this.level = level;
    }

    public void add(EntityParticle p) {
        if (p != null) {
            this.particles.add(p);
        }
    }

    public void tick() {
        int i2 = 0;
        while (i2 < this.particles.size()) {
            EntityParticle particle = this.particles.get(i2);
            if (particle != null) {
                particle.tick();
                if (particle.removed) {
                    this.particles.remove(i2--);
                }
            } else {
                this.particles.remove(i2--);
            }
            ++i2;
        }
    }

    public void render(EntityPlayer player, float a2, int layer) {
        GL11.glEnable(3553);
        float xa = -((float)Math.cos((double)player.yRot * Math.PI / 180.0));
        float za = -((float)Math.sin((double)player.yRot * Math.PI / 180.0));
        float xa2 = -za * (float)Math.sin((double)player.xRot * Math.PI / 180.0);
        float za2 = xa * (float)Math.sin((double)player.xRot * Math.PI / 180.0);
        float ya = (float)Math.cos((double)player.xRot * Math.PI / 180.0);
        HashMap<String, List> particlesByTexture = new HashMap<String, List>();
        for (EntityParticle particle : this.particles) {
            if (particle == null || !(particle.isLit() ^ layer == 1)) continue;
            String tex = particle.tex != null ? particle.tex : "";
            particlesByTexture.computeIfAbsent(tex, k -> new ArrayList()).add(particle);
        }
        Tesselator tess = Tesselator.INSTANCE;
        GL11.glColor4f(0.8f, 0.8f, 0.8f, 1.0f);
        for (Map.Entry entry : particlesByTexture.entrySet()) {
            if (!((String)entry.getKey()).isEmpty()) {
                Textures.bindNearest((String)entry.getKey());
            }
            tess.begin(7);
            for (EntityParticle particle : (List)entry.getValue()) {
                particle.render(tess, a2, xa, ya, za, xa2, za2);
            }
            tess.flush();
        }
        GL11.glDisable(3553);
    }
}

